/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.shrines.Lab;
import com.megacrit.cardcrawl.events.shrines.WomanInBlue;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.rooms.TreasureRoom;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import java.util.ArrayList;
import java.util.Iterator;

public class CombatRewardScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("CombatRewardScreen");
    public static final String[] TEXT = CombatRewardScreen.uiStrings.TEXT;
    public ArrayList<RewardItem> rewards = new ArrayList();
    public ArrayList<AbstractGameEffect> effects = new ArrayList();
    public boolean hasTakenAll = false;
    private String labelOverride = null;
    private boolean mug = false;
    private static final float REWARD_ANIM_TIME = 0.2f;
    private float rewardAnimTimer = 0.2f;
    private Color uiColor = Color.BLACK.cpy();
    private static final int SHEET_W = 612;
    private static final int SHEET_H = 716;
    private static final Color TIP_COLOR = Color.valueOf("a7b0b8ff");
    private String tip;

    public void update() {
        if (InputHelper.justClickedLeft && Settings.isDebug) {
            this.tip = CardCrawlGame.tips.getTip();
        }
        this.rewardViewUpdate();
        this.updateEffects();
    }

    private void updateEffects() {
        Iterator<AbstractGameEffect> i = this.effects.iterator();
        while (i.hasNext()) {
            AbstractGameEffect e = i.next();
            e.update();
            if (!e.isDone) continue;
            i.remove();
        }
    }

    public void setupItemReward() {
        this.rewardAnimTimer = 0.2f;
        InputHelper.justClickedLeft = false;
        this.rewards = new ArrayList<RewardItem>(AbstractDungeon.getCurrRoom().rewards);
        if (!(AbstractDungeon.getCurrRoom().event instanceof Lab) && !(AbstractDungeon.getCurrRoom().event instanceof WomanInBlue)) {
            if (!(AbstractDungeon.getCurrRoom() instanceof TreasureRoom) && !(AbstractDungeon.getCurrRoom() instanceof RestRoom)) {
                this.rewards.add(new RewardItem());
            } else if (AbstractDungeon.getCurrRoom() instanceof TreasureRoom && AbstractDungeon.player.hasRelic("Prayer Wheel")) {
                this.rewards.add(new RewardItem());
            }
        }
        AbstractDungeon.dynamicButton.hide();
        AbstractDungeon.overlayMenu.proceedButton.show();
        this.hasTakenAll = false;
        this.positionRewards();
    }

    public void positionRewards() {
        for (int i = 0; i < this.rewards.size(); ++i) {
            this.rewards.get(i).move((float)Settings.HEIGHT - 410.0f * Settings.scale - (float)i * 100.0f * Settings.scale);
        }
        if (this.rewards.isEmpty()) {
            this.hasTakenAll = true;
        }
    }

    private void rewardViewUpdate() {
        if (this.rewardAnimTimer != 0.0f) {
            this.rewardAnimTimer -= Gdx.graphics.getDeltaTime();
            if (this.rewardAnimTimer < 0.0f) {
                this.rewardAnimTimer = 0.0f;
            }
            this.uiColor.r = 1.0f - this.rewardAnimTimer / 0.2f;
            this.uiColor.g = 1.0f - this.rewardAnimTimer / 0.2f;
            this.uiColor.b = 1.0f - this.rewardAnimTimer / 0.2f;
        }
        boolean removedSomething = false;
        Iterator<RewardItem> i = this.rewards.iterator();
        while (i.hasNext()) {
            RewardItem r = i.next();
            r.update();
            if (!r.isDone) continue;
            if (r.claimReward()) {
                i.remove();
                removedSomething = true;
                continue;
            }
            if (r.type == RewardItem.RewardType.POTION) {
                r.isDone = false;
                AbstractDungeon.topPanel.flashRed();
                this.tip = CardCrawlGame.tips.getPotionTip();
                continue;
            }
            if (r.type != RewardItem.RewardType.CARD) continue;
            r.isDone = false;
        }
        if (removedSomething) {
            this.positionRewards();
            this.setLabel();
        }
    }

    private void setLabel() {
        if (this.rewards.size() == 0) {
            AbstractDungeon.overlayMenu.proceedButton.setLabel(TEXT[0]);
        } else if (this.rewards.size() == 1) {
            switch (this.rewards.get((int)0).type) {
                case CARD: {
                    AbstractDungeon.overlayMenu.proceedButton.setLabel(TEXT[1]);
                    break;
                }
                case GOLD: {
                    AbstractDungeon.overlayMenu.proceedButton.setLabel(TEXT[2]);
                    break;
                }
                case POTION: {
                    AbstractDungeon.overlayMenu.proceedButton.setLabel(TEXT[3]);
                    break;
                }
                case RELIC: {
                    AbstractDungeon.overlayMenu.proceedButton.setLabel(TEXT[4]);
                    break;
                }
            }
        } else {
            AbstractDungeon.overlayMenu.proceedButton.setLabel(TEXT[5]);
        }
    }

    public void render(SpriteBatch sb) {
        this.renderItemReward(sb);
        FontHelper.renderFontCentered(sb, FontHelper.rewardTipFont, TEXT[12] + this.tip, (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT - 1010.0f * Settings.scale, TIP_COLOR);
        for (AbstractGameEffect e : this.effects) {
            e.render(sb);
        }
    }

    private void renderItemReward(SpriteBatch sb) {
        AbstractDungeon.overlayMenu.proceedButton.render(sb);
        sb.setColor(this.uiColor);
        sb.draw(ImageMaster.REWARD_SCREEN_SHEET, (float)Settings.WIDTH / 2.0f - 306.0f, (float)Settings.HEIGHT - 584.0f * Settings.scale - 358.0f, 306.0f, 358.0f, 612.0f, 716.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 612, 716, false, false);
        for (RewardItem i : this.rewards) {
            i.render(sb);
        }
    }

    public void reopen() {
        this.rewardAnimTimer = 0.2f;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
        AbstractDungeon.topPanel.unhoverHitboxes();
        AbstractDungeon.isScreenUp = true;
        if (this.labelOverride == null || this.mug) {
            if (this.mug) {
                AbstractDungeon.dynamicBanner.appear(this.labelOverride);
            } else {
                AbstractDungeon.dynamicBanner.appear(this.getRandomBannerLabel());
            }
            AbstractDungeon.overlayMenu.proceedButton.show();
        } else {
            AbstractDungeon.dynamicBanner.appear(this.labelOverride);
            AbstractDungeon.overlayMenu.cancelButton.show(TEXT[6]);
        }
        this.setLabel();
    }

    public void open(String setLabel) {
        this.labelOverride = setLabel;
        this.mug = false;
        this.tip = CardCrawlGame.tips.getTip();
        this.rewardAnimTimer = 0.5f;
        AbstractDungeon.topPanel.unhoverHitboxes();
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
        AbstractDungeon.dynamicBanner.appear(setLabel);
        AbstractDungeon.overlayMenu.showBlackScreen();
        this.setupItemReward();
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.cancelButton.show(TEXT[6]);
        for (RewardItem r : this.rewards) {
            if (r.type != RewardItem.RewardType.RELIC) continue;
            UnlockTracker.markRelicAsSeen(r.relic.relicId);
        }
    }

    public void openCombat(String setLabel) {
        this.labelOverride = setLabel;
        this.mug = true;
        this.tip = CardCrawlGame.tips.getTip();
        this.rewardAnimTimer = 0.5f;
        AbstractDungeon.topPanel.unhoverHitboxes();
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
        AbstractDungeon.dynamicBanner.appear(setLabel);
        AbstractDungeon.overlayMenu.showBlackScreen();
        this.setupItemReward();
        this.setLabel();
        for (RewardItem r : this.rewards) {
            if (r.type != RewardItem.RewardType.RELIC) continue;
            UnlockTracker.markRelicAsSeen(r.relic.relicId);
        }
    }

    public void load() {
        this.tip = CardCrawlGame.tips.getTip();
        this.mug = false;
        this.rewardAnimTimer = 0.5f;
        AbstractDungeon.topPanel.unhoverHitboxes();
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
        AbstractDungeon.dynamicBanner.appear(this.getRandomBannerLabel());
        this.labelOverride = null;
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.showBlackScreen();
        this.setLabel();
    }

    public void open() {
        this.tip = CardCrawlGame.tips.getTip();
        this.mug = false;
        this.rewardAnimTimer = 0.5f;
        AbstractDungeon.topPanel.unhoverHitboxes();
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
        AbstractDungeon.dynamicBanner.appear(this.getRandomBannerLabel());
        this.labelOverride = null;
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.showBlackScreen();
        this.setupItemReward();
        this.setLabel();
        for (RewardItem r : this.rewards) {
            if (r.type != RewardItem.RewardType.RELIC) continue;
            UnlockTracker.markRelicAsSeen(r.relic.relicId);
        }
    }

    private String getRandomBannerLabel() {
        ArrayList<String> list = new ArrayList<String>();
        if (AbstractDungeon.getCurrRoom() instanceof TreasureRoom) {
            list.add(TEXT[7]);
            list.add(TEXT[8]);
        } else {
            list.add(TEXT[9]);
            list.add(TEXT[10]);
            list.add(TEXT[11]);
        }
        return (String)list.get(MathUtils.random(list.size() - 1));
    }

    public void clear() {
        this.rewards.clear();
    }
}

